/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -2732129344472207193L;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    int align;
    protected int hgap;
    protected int vgap;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            Boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (firstVisibleComponent.booleanValue()) {
                    firstVisibleComponent = false;
                } else {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 0: {
                    y += ltr ? 0 : height;
                    break;
                }
                case 1: {
                    y += height / 2;
                    break;
                }
                case 2: {
                    y += ltr ? height : 0;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ltr) {
                    m.setLocation(x, y);
                } else {
                    m.setLocation(x, target.getHeight() - y - m.getHeight());
                }
                y += m.getHeight() + this.vgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxlen = target.getHeight() - (insets.top + insets.bottom + this.vgap * 2);
            int nmembers = target.getComponentCount();
            int x = insets.left + this.hgap;
            int y = 0;
            int roww = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (y == 0 || y + d.height <= maxlen) {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d.height;
                    roww = Math.max(roww, d.width);
                    continue;
                }
                this.moveComponents(target, x, insets.top + this.vgap, roww, maxlen - y, start, i, ltr);
                y = d.height;
                x += this.hgap + roww;
                roww = d.width;
                start = i;
            }
            this.moveComponents(target, x, insets.top + this.vgap, roww, maxlen - y, start, nmembers, ltr);
        }
    }
}

