/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.UUID;
import speiger.src.data.CollectableType;
import speiger.src.data.Registry;

public class Marker {
    UUID id;
    CollectableType type;
    Point point;
    Image[] display;
    String name;
    boolean disabled;
    int size = 32;
    boolean hovered;

    public Marker(UUID id, CollectableType type, String name, Point point, Image[] display) {
        this.id = id;
        this.type = type;
        this.point = point;
        this.display = display;
        this.name = name;
        this.disabled = Registry.INSTANCE.isCompleted(id);
    }

    public void toggle() {
        this.setCompletion(!this.disabled);
    }

    public void setCompletion(boolean value) {
        this.disabled = value;
        if (this.disabled) {
            Registry.INSTANCE.markComplete(this.id);
        } else {
            Registry.INSTANCE.unmarkComplete(this.id);
        }
    }

    public String name() {
        return this.name;
    }

    public UUID id() {
        return this.id;
    }

    public CollectableType type() {
        return this.type;
    }

    public boolean isHovered(Point mouse, float scale) {
        int rad = Math.clamp((long)((int)(32.0f / scale)), 5, 32) >> 1;
        return mouse.x >= this.point.x - rad && mouse.x <= this.point.x + rad && mouse.y >= this.point.y - rad && mouse.y <= this.point.y + rad;
    }

    public boolean collides(Rectangle rect, float scale) {
        int rad = Math.clamp((long)((int)(32.0f / scale)), 5, 32) >> 1;
        return rect.intersects(this.point.x - rad, this.point.y - rad, rad * 2, rad * 2);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setHovered(boolean value) {
        this.hovered = value;
    }

    public void updateCompletion() {
        this.disabled = Registry.INSTANCE.isCompleted(this.id);
    }

    public void draw(Graphics2D g, float scale) {
        int realSize = Math.clamp((long)((int)(32.0f / scale)), 5, 32);
        g.drawImage(this.display[this.disabled ? 1 : 0], this.point.x - (realSize >> 1), this.point.y - (realSize >> 1), realSize, realSize, null);
    }

    public void drawHover(Graphics2D g, float scale) {
        int realSize = Math.clamp((long)((int)(32.0f / scale)), 5, 32);
        if (this.hovered) {
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(1.0f / scale * 2.0f));
            g.drawRect(this.point.x - (realSize >> 1), this.point.y - (realSize >> 1), realSize, realSize);
        }
    }
}

