/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import speiger.src.data.Collectable;
import speiger.src.data.CollectableType;
import speiger.src.data.Registry;
import speiger.src.ui.LocationDisplay;
import speiger.src.ui.Marker;

public class MapPanel
extends JPanel {
    private static final long serialVersionUID = 7639401429824622357L;
    JFrame owner;
    Runnable progressUpdate;
    float zoom = 1.0f;
    Point offset = new Point(-568, -271);
    Point lastDrag = null;
    Point startPos;
    Point lastPos;
    Image map = new ImageIcon(MapPanel.class.getResource("/assets/images/map.png")).getImage();
    Image[] medal = new Image[]{new ImageIcon(MapPanel.class.getResource("/assets/images/medal.png")).getImage(), new ImageIcon(MapPanel.class.getResource("/assets/images/medal_disabled.png")).getImage()};
    Image[] panel = new Image[]{new ImageIcon(MapPanel.class.getResource("/assets/images/panel.png")).getImage(), new ImageIcon(MapPanel.class.getResource("/assets/images/panel_disabled.png")).getImage()};
    Image[] pswitch = new Image[]{new ImageIcon(MapPanel.class.getResource("/assets/images/pswitch.png")).getImage(), new ImageIcon(MapPanel.class.getResource("/assets/images/pswitch_disabled.png")).getImage()};
    Image[] chuck = new Image[]{new ImageIcon(MapPanel.class.getResource("/assets/images/chucks.png")).getImage(), new ImageIcon(MapPanel.class.getResource("/assets/images/chucks_disabled.png")).getImage()};
    List<Marker> markers = new ArrayList<Marker>();
    List<Marker> visibleMarkers = new ArrayList<Marker>();
    Marker lastMarker = null;

    private Image[] fromType(CollectableType type) {
        return switch (type) {
            case CollectableType.MEDAL -> this.medal;
            case CollectableType.PANEL -> this.panel;
            case CollectableType.PSWITCH -> this.pswitch;
            case CollectableType.CHUCKS -> this.chuck;
            default -> this.pswitch;
        };
    }

    public MapPanel(final JFrame frame) {
        this.owner = frame;
        Registry.INSTANCE.load();
        for (Collectable entry : Registry.INSTANCE.collectables()) {
            Marker marker = new Marker(entry.id(), entry.type(), entry.name(), entry.position(), this.fromType(entry.type()));
            this.markers.add(marker);
            this.visibleMarkers.add(marker);
        }
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double lastZoom = MapPanel.this.zoom;
                MapPanel.this.zoom = e.getPreciseWheelRotation() < 0.0 ? MapPanel.this.zoom * 1.1f : MapPanel.this.zoom / 1.1f;
                Point mouse = e.getPoint();
                double scaleDiff = (double)MapPanel.this.zoom / lastZoom;
                MapPanel.this.offset.x = (int)((double)mouse.x - scaleDiff * (double)(mouse.x - MapPanel.this.offset.x));
                MapPanel.this.offset.y = (int)((double)mouse.y - scaleDiff * (double)(mouse.y - MapPanel.this.offset.y));
                MapPanel.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MapPanel.this.lastDrag = e.getPoint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Marker marker;
                MapPanel.this.lastPos = MapPanel.this.screenToMap(e.getPoint());
                if (MapPanel.this.startPos != null) {
                    MapPanel.this.repaint();
                }
                if ((marker = MapPanel.this.findMarker(MapPanel.this.lastPos, MapPanel.this.zoom)) == MapPanel.this.lastMarker) {
                    return;
                }
                if (MapPanel.this.lastMarker != null) {
                    MapPanel.this.lastMarker.setHovered(false);
                }
                MapPanel.this.lastMarker = marker;
                if (marker == null) {
                    return;
                }
                marker.setHovered(true);
                MapPanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MapPanel.this.lastDrag == null) {
                    return;
                }
                MapPanel.this.offset.translate((int)((double)e.getX() - MapPanel.this.lastDrag.getX()), (int)((double)e.getY() - MapPanel.this.lastDrag.getY()));
                MapPanel.this.lastDrag = e.getPoint();
                MapPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MapPanel.this.startPos != null) {
                    if (e.getButton() == 1) {
                        int result = JOptionPane.showOptionDialog(frame, "What do you want to do?", "Bulk Marking", -1, 3, null, new Object[]{"Complete", "Uncomplete", "Cancel"}, "Complete");
                        if (result == 2) {
                            return;
                        }
                        List<Marker> markers = MapPanel.this.getMarkers(MapPanel.this.getMarkedArea(), MapPanel.this.zoom);
                        if (markers.isEmpty()) {
                            return;
                        }
                        boolean completion = result == 0;
                        Registry.INSTANCE.setBulkOperation(true);
                        markers.forEach(T -> T.setCompletion(completion));
                        Registry.INSTANCE.setBulkOperation(false);
                        MapPanel.this.startPos = null;
                        MapPanel.this.repaint();
                    }
                    return;
                }
                Point hover = MapPanel.this.screenToMap(e.getPoint());
                Marker marker = MapPanel.this.findMarker(hover, MapPanel.this.zoom);
                if (marker == null) {
                    return;
                }
                if (e.getButton() == 1) {
                    marker.toggle();
                    MapPanel.this.repaint();
                    if (MapPanel.this.progressUpdate != null) {
                        MapPanel.this.progressUpdate.run();
                    }
                } else if (e.getButton() == 3) {
                    Collectable element = Registry.INSTANCE.get(marker.id());
                    new LocationDisplay(MapPanel.this.owner, element.name(), element.images());
                }
            }
        };
        this.addMouseListener(adapter);
        this.addMouseWheelListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    public void setProgressListener(Runnable run) {
        this.progressUpdate = run;
    }

    public void startBulkMarking(Point point) {
        this.startPos = this.screenToMap(point);
    }

    public void onImported() {
        this.markers.forEach(Marker::updateCompletion);
        EventQueue.invokeLater(this::repaint);
    }

    public void resetZoom() {
        this.zoom = 1.0f;
        EventQueue.invokeLater(this::repaint);
    }

    public void resetMap() {
        int imgWidth = this.map.getWidth(this);
        int imgHeight = this.map.getHeight(this);
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        if (imgWidth > 0 && imgHeight > 0 && panelWidth > 0 && panelHeight > 0) {
            this.offset.setLocation((panelWidth - (int)((float)imgWidth * this.zoom)) / 2, (panelHeight - (int)((float)imgHeight * this.zoom)) / 2);
        }
        EventQueue.invokeLater(this::repaint);
    }

    public void updateFilter(EnumSet<CollectableType> types) {
        this.visibleMarkers.clear();
        this.markers.forEach(T -> {
            if (types.contains((Object)T.type())) {
                this.visibleMarkers.add((Marker)T);
            }
        });
        EventQueue.invokeLater(this::repaint);
    }

    public void setCompletionState(boolean value) {
        Registry.INSTANCE.setBulkOperation(true);
        this.visibleMarkers.forEach(T -> T.setCompletion(value));
        Registry.INSTANCE.setBulkOperation(false);
        EventQueue.invokeLater(this::repaint);
        if (this.progressUpdate != null) {
            this.progressUpdate.run();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        AffineTransform at = new AffineTransform();
        at.translate(this.offset.x, this.offset.y);
        at.scale(this.zoom, this.zoom);
        g2.setTransform(at);
        g2.drawImage(this.map, 0, 0, this);
        for (Marker marker : this.visibleMarkers) {
            marker.draw(g2, this.zoom);
        }
        for (Marker marker : this.visibleMarkers) {
            marker.drawHover(g2, this.zoom);
        }
        if (this.startPos != null && this.lastPos != null) {
            Point start = new Point(this.startPos);
            Point end = new Point(this.lastPos);
            if (start.x > end.x) {
                int x = start.x;
                start.x = end.x;
                end.x = x;
            }
            if (start.y > end.y) {
                int y = start.y;
                start.y = end.y;
                end.y = y;
            }
            g2.setColor(Color.BLUE);
            g2.drawRect(start.x, start.y, end.x - start.x, end.y - start.y);
        }
    }

    private Rectangle getMarkedArea() {
        Point start = new Point(this.startPos);
        Point end = new Point(this.lastPos);
        if (start.x > end.x) {
            int x = start.x;
            start.x = end.x;
            end.x = x;
        }
        if (start.y > end.y) {
            int y = start.y;
            start.y = end.y;
            end.y = y;
        }
        return new Rectangle(start.x, start.y, end.x - start.x, end.y - start.y);
    }

    private List<Marker> getMarkers(Rectangle rect, float scale) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        int m = this.visibleMarkers.size();
        for (int i = 0; i < m; ++i) {
            Marker marker = this.visibleMarkers.get(i);
            if (!marker.collides(rect, scale)) continue;
            markers.add(marker);
        }
        return markers;
    }

    private Marker findMarker(Point point, float scale) {
        int m = this.visibleMarkers.size();
        for (int i = 0; i < m; ++i) {
            Marker marker = this.visibleMarkers.get(i);
            if (!marker.isHovered(point, scale)) continue;
            return marker;
        }
        return null;
    }

    private Point screenToMap(Point screenPoint) {
        int mapX = (int)((float)(screenPoint.x - this.offset.x) / this.zoom);
        int mapY = (int)((float)(screenPoint.y - this.offset.y) / this.zoom);
        return new Point(mapX, mapY);
    }
}

