/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import speiger.src.data.Registry;
import speiger.src.data.TaggedImage;

public class LocationDisplay
extends JDialog {
    private static final long serialVersionUID = 3803744617604239360L;

    public LocationDisplay(JFrame owner, String name, Map<String, TaggedImage> images) {
        this.setTitle(name + " Images");
        this.setBounds(0, 0, 700, 700);
        this.setResizable(true);
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "Center");
        images.forEach((K, V) -> {
            JPanel panel = new JPanel(new BorderLayout());
            tabbedPane.addTab(LocationDisplay.firstLetterUppercase(K), panel);
            Thread.ofPlatform().name("Image Loader", 1L).start(() -> {
                BufferedImage image = Registry.INSTANCE.getImage((TaggedImage)V);
                if (image == null) {
                    EventQueue.invokeLater(() -> tabbedPane.remove(panel));
                    return;
                }
                EventQueue.invokeLater(() -> {
                    panel.add((Component)new ImagePanel(image, this), "Center");
                    this.repaint();
                });
            });
        });
        this.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LocationDisplay.this.repaint();
            }
        });
    }

    public static String firstLetterUppercase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String first = Character.toString(string.charAt(0));
        return string.replaceFirst(first, first.toUpperCase());
    }

    private static class ImagePanel
    extends Panel {
        private static final long serialVersionUID = 5945747347624323542L;
        BufferedImage image;

        public ImagePanel(BufferedImage image, final JDialog owner) {
            this.image = image;
            this.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent e) {
                    owner.dispose();
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }
}

