/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import speiger.src.data.Collectable;
import speiger.src.data.CollectableType;
import speiger.src.data.EndPoint;
import speiger.src.data.TaggedImage;

public class Registry {
    public static final Registry INSTANCE = new Registry();
    ExecutorService service = Executors.newFixedThreadPool(4);
    ExecutorCompletionService<DownloadedImage> queue = new ExecutorCompletionService(this.service);
    Map<UUID, Collectable> collectables = new LinkedHashMap<UUID, Collectable>();
    Set<UUID> completed = new HashSet<UUID>();
    Object syncObj = new Object();
    boolean bulkOperationActive = false;

    public void load() {
        this.parseRegistry("/assets/data/medals.json", CollectableType.MEDAL);
        this.parseRegistry("/assets/data/panels.json", CollectableType.PANEL);
        this.parseRegistry("/assets/data/pswitches.json", CollectableType.PSWITCH);
        this.parseRegistry("/assets/data/chucks.json", CollectableType.CHUCKS);
        this.dumpData();
        this.loadCompleted();
    }

    private void dumpData() {
        Path path = Registry.getOrigin().resolve("data");
        if (Files.exists(path.resolve("images.zip"), new LinkOption[0])) {
            return;
        }
        try (InputStream stream = Registry.class.getResourceAsStream("/assets/images/images.zip");){
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            Files.copy(stream, path.resolve("images.zip"), new CopyOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void importSave(List<UUID> ids) {
        this.completed.clear();
        this.completed.addAll(ids);
        this.save();
    }

    private void loadCompleted() {
        this.completed.clear();
        Path path = Registry.getOrigin().resolve("data/save.json");
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            for (JsonElement element : JsonParser.parseReader(reader).getAsJsonObject().getAsJsonArray("completed")) {
                this.completed.add(UUID.fromString(element.getAsString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        JsonArray array = new JsonArray();
        this.completed.forEach(T -> array.add(T.toString()));
        Path path = Registry.getOrigin().resolve("data");
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try (JsonWriter writer = new JsonWriter(Files.newBufferedWriter(path.resolve("save.json"), new OpenOption[0]));){
            writer.setIndent("\t");
            JsonObject obj = new JsonObject();
            obj.add("completed", array);
            Streams.write(obj, writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        ArrayList<DownloadedImage> images = new ArrayList<DownloadedImage>();
        Future<DownloadedImage> data = null;
        while ((data = this.queue.poll()) != null) {
            try {
                images.add(data.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object object = this.syncObj;
        synchronized (object) {
            try (FileSystem system = FileSystems.newFileSystem(Registry.getOrigin().resolve("data/images.zip"), Map.of("create", "true"));){
                for (DownloadedImage image : images) {
                    if (image.id() == null) continue;
                    Path path = system.getPath(image.id().toString().replace("-", "_") + ".jpg", new String[0]);
                    try {
                        OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);
                        try {
                            ImageIO.write((RenderedImage)image.image(), "jpg", new BufferedOutputStream(stream));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseRegistry(String path, CollectableType type) {
        try (InputStreamReader reader = new InputStreamReader(Registry.class.getResourceAsStream(path));){
            for (JsonElement element : JsonParser.parseReader(reader).getAsJsonObject().getAsJsonArray("entries")) {
                try {
                    Collectable entry = Registry.parse(element.getAsJsonObject(), type);
                    this.collectables.put(entry.id(), entry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getImage(TaggedImage image) {
        Path path = Registry.getOrigin().resolve("data/images.zip");
        if (Files.exists(path, new LinkOption[0])) {
            Object object = this.syncObj;
            synchronized (object) {
                try (FileSystem system = FileSystems.newFileSystem(path);){
                    Path resolve = system.getPath(image.fileId().toString().replace("-", "_") + ".jpg", new String[0]);
                    if (Files.exists(resolve, new LinkOption[0])) {
                        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(Files.readAllBytes(resolve)));
                        return bufferedImage;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            return this.queue.submit(new DownloadTask(image)).get().image();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collectable get(UUID id) {
        return this.collectables.get(id);
    }

    public int completed(CollectableType type) {
        return (int)this.collectables.values().stream().filter(T -> this.completed.contains(T.id())).filter(T -> T.type() == type).count();
    }

    public int total(CollectableType type) {
        return (int)this.collectables.values().stream().filter(T -> T.type() == type).count();
    }

    public void markComplete(UUID id) {
        this.completed.add(id);
        if (!this.bulkOperationActive) {
            this.save();
        }
    }

    public void unmarkComplete(UUID id) {
        this.completed.remove(id);
        if (!this.bulkOperationActive) {
            this.save();
        }
    }

    public void setBulkOperation(boolean bulk) {
        this.bulkOperationActive = bulk;
        if (!bulk) {
            this.save();
        }
    }

    public boolean isCompleted(UUID id) {
        return this.completed.contains(id);
    }

    public List<Collectable> collectables() {
        return new ArrayList<Collectable>(this.collectables.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadMissingIcons(Consumer<int[]> progressTracker, AtomicBoolean cancel, Runnable completion) {
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorCompletionService<DownloadedImage> queue = new ExecutorCompletionService<DownloadedImage>(service);
        Object object = this.syncObj;
        synchronized (object) {
            Map<Object, Object> done = Map.of();
            if (Files.notExists(Registry.getOrigin().resolve("data/images.zip"), new LinkOption[0])) {
                done = Map.of("create", "true");
            }
            try (FileSystem system = FileSystems.newFileSystem(Registry.getOrigin().resolve("data/images.zip"), done);){
                int toDo = 0;
                for (Collectable collect : INSTANCE.collectables()) {
                    for (TaggedImage image : collect.images().values()) {
                        Path path = system.getPath(image.fileId().toString().replace("-", "_") + ".jpg", new String[0]);
                        if (Files.exists(path, new LinkOption[0])) continue;
                        queue.submit(new DownloadTask(image, cancel));
                        ++toDo;
                    }
                }
                int total = toDo;
                progressTracker.accept(new int[]{0, total});
                service.shutdown();
                while (toDo > 0) {
                    Future future = null;
                    while ((future = queue.poll()) != null) {
                        DownloadedImage image = (DownloadedImage)future.get();
                        --toDo;
                        if (image.id() == null) continue;
                        Path path = system.getPath(image.id().toString().replace("-", "_") + ".jpg", new String[0]);
                        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
                            ImageIO.write((RenderedImage)image.image(), "jpg", new BufferedOutputStream(stream));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        progressTracker.accept(new int[]{total - toDo, total});
                        Thread.sleep(Duration.ofMillis(50L));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        completion.run();
    }

    private static Collectable parse(JsonObject obj, CollectableType type) {
        String name = obj.get("name").getAsString();
        UUID id = UUID.fromString(obj.get("id").getAsString());
        Point pos = Registry.parsePosition(obj.getAsJsonObject("position"));
        EndPoint point = Registry.parseEnd(obj.getAsJsonObject("end"));
        HashMap<String, TaggedImage> images = new HashMap<String, TaggedImage>();
        for (JsonElement el : obj.getAsJsonArray("images")) {
            TaggedImage image = Registry.parseImage(el.getAsJsonObject());
            images.put(image.tag(), image);
        }
        return new Collectable(name, id, type, pos, point, images);
    }

    private static TaggedImage parseImage(JsonObject obj) {
        return new TaggedImage(UUID.fromString(obj.get("id").getAsString()), obj.get("url").getAsString(), obj.get("type").getAsString());
    }

    private static EndPoint parseEnd(JsonObject obj) {
        return obj == null ? null : new EndPoint(Registry.parsePosition(obj), obj.get("flying").getAsBoolean());
    }

    private static Point parsePosition(JsonObject obj) {
        return new Point(obj.get("x").getAsInt(), obj.get("y").getAsInt());
    }

    public static Path getOrigin() {
        try {
            Path data = Path.of(Registry.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!Files.isDirectory(data, new LinkOption[0])) {
                return data.getParent();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return Path.of("", new String[0]);
    }

    private record DownloadedImage(UUID id, BufferedImage image) {
    }

    private static class DownloadTask
    implements Callable<DownloadedImage> {
        TaggedImage image;
        AtomicBoolean cancel;

        public DownloadTask(TaggedImage image) {
            this.image = image;
        }

        public DownloadTask(TaggedImage image, AtomicBoolean cancel) {
            this.image = image;
            this.cancel = cancel;
        }

        @Override
        public DownloadedImage call() throws Exception {
            if (this.cancel != null && this.cancel.get()) {
                return new DownloadedImage(null, null);
            }
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                WritableByteChannel output = Channels.newChannel(stream);
                ReadableByteChannel input = Channels.newChannel(new URI(this.image.url().replace(" ", "%20")).toURL().openStream());
                ByteBuffer buffer = ByteBuffer.allocate(8192);
                while (input.read(buffer) > 0) {
                    output.write(buffer.flip());
                    buffer.flip();
                }
                input.close();
                output.close();
                return new DownloadedImage(this.image.fileId(), ImageIO.read(new ByteArrayInputStream(stream.toByteArray())));
            }
            catch (Exception e) {
                e.printStackTrace();
                return new DownloadedImage(null, null);
            }
        }
    }
}

